/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.link;

import com.ibm.hwmca.fw.rcs.RcsControl;
import com.ibm.hwmca.fw.rcs.link.LinkAlreadyActiveException;
import com.ibm.hwmca.fw.rcs.link.LinkFailedException;
import com.ibm.hwmca.fw.rcs.link.LinkNotConfiguredException;
import com.ibm.hwmca.fw.rcs.link.RcsLink;
import com.ibm.hwmca.fw.util.Trace;

public class RemoteServiceDialLink
extends RcsLink {
    private static final String TRACE_MASKT = "XRCSLDLT";
    private static final String TRACE_MASKF = "XRCSLDLF";
    private static final String TRACE_MASKD = "XRCSLDLD";
    private static RemoteServiceDialLink instance;

    protected RemoteServiceDialLink() {
        this.maxOpenPaths = 5;
        Trace.trace(TRACE_MASKT, "<-> RemoteServiceDialLink()");
    }

    public static RcsLink getInstance() {
        if (instance == null) {
            instance = new RemoteServiceDialLink();
        }
        Trace.trace(TRACE_MASKT, "<-> getInstance() [" + instance + "]");
        return instance;
    }

    public void activate() throws LinkAlreadyActiveException, LinkFailedException, LinkNotConfiguredException {
        Trace.trace(TRACE_MASKT, "--> activate()");
        try {
            int rc = 0;
            rc = RcsControl.queryModem();
            if (rc == 0) {
                throw new LinkFailedException("Failed to detect a modem (RC:" + rc + ")");
            }
            rc = RcsControl.startServiceDial();
            if (rc != 0) {
                this.active = false;
                throw new LinkFailedException("Failed to start remote service dial (RC: " + rc + ")");
            }
            this.active = true;
        }
        catch (LinkFailedException e) {
            throw e;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception: " + e);
        }
        Trace.trace(TRACE_MASKT, "<-- activate()");
    }

    public void deactivate() {
        Trace.trace(TRACE_MASKT, "--> deactivate()");
        try {
            RcsControl.stopServiceDial();
            RcsControl.resetModem();
            this.active = false;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception: " + e);
        }
        Trace.trace(TRACE_MASKT, "<-- deactivate()");
    }
}

